unit K8061dmo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, Math, Buttons;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    Button3: TButton;
    Label12: TLabel;
    GroupBox2: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    GroupBox3: TGroupBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    CheckBox11: TCheckBox;
    CheckBox12: TCheckBox;
    CheckBox13: TCheckBox;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Timer2: TTimer;
    SpeedButton1: TSpeedButton;
    GroupBox6: TGroupBox;
    TrackBar1: TTrackBar;
    Label10: TLabel;
    GroupBox7: TGroupBox;
    TrackBar2: TTrackBar;
    Label7: TLabel;
    GroupBox8: TGroupBox;
    ProgressBar1: TProgressBar;
    Label14: TLabel;
    GroupBox9: TGroupBox;
    ProgressBar2: TProgressBar;
    Label16: TLabel;
    RadioGroup3: TRadioGroup;
    CheckBox14: TCheckBox;
    CheckBox15: TCheckBox;
    CheckBox16: TCheckBox;
    GroupBox4: TGroupBox;
    Label1: TLabel;
    ProgressBar3: TProgressBar;
    GroupBox5: TGroupBox;
    Label2: TLabel;
    ProgressBar4: TProgressBar;
    GroupBox10: TGroupBox;
    Label3: TLabel;
    ProgressBar5: TProgressBar;
    GroupBox11: TGroupBox;
    Label4: TLabel;
    ProgressBar6: TProgressBar;
    GroupBox12: TGroupBox;
    Label5: TLabel;
    ProgressBar7: TProgressBar;
    GroupBox13: TGroupBox;
    Label6: TLabel;
    ProgressBar8: TProgressBar;
    GroupBox14: TGroupBox;
    Label8: TLabel;
    TrackBar3: TTrackBar;
    GroupBox15: TGroupBox;
    Label9: TLabel;
    TrackBar4: TTrackBar;
    GroupBox16: TGroupBox;
    Label11: TLabel;
    TrackBar5: TTrackBar;
    GroupBox17: TGroupBox;
    Label13: TLabel;
    TrackBar6: TTrackBar;
    GroupBox18: TGroupBox;
    Label15: TLabel;
    TrackBar7: TTrackBar;
    GroupBox19: TGroupBox;
    Label17: TLabel;
    TrackBar8: TTrackBar;
    GroupBox20: TGroupBox;
    Label18: TLabel;
    TrackBar9: TTrackBar;
    Label19: TLabel;
    Label20: TLabel;
    Button1: TButton;
    Label21: TLabel;
    Label22: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button3Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure TrackBar2Change(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure DigitalOut(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure RadioGroup3Click(Sender: TObject);
    procedure TrackBar9Change(Sender: TObject);
    procedure TrackBar3Change(Sender: TObject);
    procedure TrackBar4Change(Sender: TObject);
    procedure TrackBar5Change(Sender: TObject);
    procedure TrackBar6Change(Sender: TObject);
    procedure TrackBar7Change(Sender: TObject);
    procedure TrackBar8Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ReadBackCardOutput;
  
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;    
  timed:boolean;
  n, CardAddress:longint;
  DisableOtherFunctionCall:boolean;

implementation

{$R *.DFM}
function OpenDevice: Longint; stdcall; external 'K8061.dll';
procedure CloseDevices; stdcall; external 'K8061.dll';
procedure CloseDevice(CardAddress: Longint); stdcall; external 'K8061.dll';
function ReadAnalogChannel(CardAddress: Longint; Channel: Longint):Longint; stdcall; external 'K8061.dll';
procedure ReadAllAnalog(CardAddress: Longint; Buffer: Pointer); stdcall; external 'K8061.dll';
procedure OutputAnalogChannel(CardAddress: Longint; Channel: Longint; Data: Longint); stdcall; external 'K8061.dll';
procedure OutputAllAnalog(CardAddress: Longint; Buffer: Pointer); stdcall; external 'K8061.dll';
procedure ClearAnalogChannel(CardAddress: Longint; Channel: Longint); stdcall; external 'K8061.dll';
procedure ClearAllAnalog(CardAddress: Longint) ; stdcall; external 'K8061.dll';
procedure SetAnalogChannel(CardAddress: Longint; Channel: Longint); stdcall; external 'K8061.dll';
procedure SetAllAnalog(CardAddress: Longint); stdcall; external 'K8061.dll';
procedure OutputAllDigital(CardAddress: Longint; Data: Longint);stdcall;  external 'K8061.dll';
procedure ClearDigitalChannel(CardAddress: Longint; Channel: Longint); stdcall; external 'K8061.dll';
procedure ClearAllDigital(CardAddress: Longint); stdcall; external 'K8061.dll';
procedure SetDigitalChannel(CardAddress: Longint; Channel: Longint); stdcall; external 'K8061.dll';
procedure SetAllDigital(CardAddress: Longint); stdcall; external 'K8061.dll';
function ReadDigitalChannel(CardAddress: Longint; Channel: Longint): Boolean; stdcall; external 'K8061.dll';
function ReadAllDigital(CardAddress: Longint): Longint; stdcall; external 'K8061.dll';
procedure OutputPWM(CardAddress: Longint; Data: Longint); stdcall; external 'K8061.dll';
function PowerGood(CardAddress: Longint): Boolean; stdcall; external 'K8061.dll';
function Connected(CardAddress: Longint): Boolean; stdcall; external 'K8061.dll';
procedure ReadVersion(CardAddress: Longint; Buffer: Pointer); stdcall; external 'K8061.dll';
function ReadBackDigitalOut(CardAddress: Longint): Longint; stdcall; external 'K8061.dll';
procedure ReadBackAnalogOut(CardAddress: Longint; Buffer: Pointer ); stdcall; external 'K8061.dll';
function ReadBackPWMOut(CardAddress: Longint):Longint; stdcall; external 'K8061.dll';

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  CloseDevices;
end;

procedure TForm1.Button3Click(Sender: TObject);
var h:longint;
begin
  h:= OpenDevice;
  case h of
    0..7: begin
            label12.caption:='Card '+ inttostr(h)+' connected';
            RadioGroup3.items[h]:=inttostr(h);
            RadioGroup3.enabled:=true;
            RadioGroup3.itemindex:=h;
            timer1.enabled:=true;
            CardAddress:=h;
            ReadBackCardOutput;
          end;
    -1: label12.caption:='All cards connected.';
    -2: label12.caption:='Card not found.';
  end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var i: longint;
Data: array [0..8] of longint;
begin
  timer1.enabled:=false;
  if PowerGood(CardAddress) then
  begin
    Label19.Caption:='CPU OK';
    Label19.Font.Color:=$8000;
  end
  else
  begin
    Label19.Caption:='CPU FAIL';
    Label19.Font.Color:=ClRed;
  end;
   if Connected(CardAddress) then
  begin
    Label20.Caption:='USB Connected';
    Label20.Font.Color:=$8000;
  end
  else
  begin
    Label20.Caption:='USB Disconnected';
    Label20.Font.Color:=ClRed;
    label12.caption:='Card disconnected';
  end;

  ReadAllAnalog(CardAddress,@Data[0]);
  ProgressBar1.Position:=Data[0];
  ProgressBar2.Position:=Data[1];
  ProgressBar3.Position:=Data[2];
  ProgressBar4.Position:=Data[3];
  ProgressBar5.Position:=Data[4];
  ProgressBar6.Position:=Data[5];
  ProgressBar7.Position:=Data[6];
  ProgressBar8.Position:=Data[7];

  Label14.caption:=inttostr(Data[0]);
  Label16.caption:=inttostr(Data[1]);
  Label1.caption:=inttostr(Data[2]);
  Label2.caption:=inttostr(Data[3]);
  Label3.caption:=inttostr(Data[4]);
  Label4.caption:=inttostr(Data[5]);
  Label5.caption:=inttostr(Data[6]);
  Label6.caption:=inttostr(Data[7]); 

  i:=ReadAllDigital(CardAddress);
  CheckBox1.checked:=(i and 1)>0;
  CheckBox2.checked:=(i and 2)>0;
  CheckBox3.checked:=(i and 4)>0;
  CheckBox4.checked:=(i and 8)>0;
  CheckBox5.checked:=(i and 16)>0;
  CheckBox14.checked:=(i and 32)>0;
  CheckBox15.checked:=(i and 64)>0;
  CheckBox16.checked:=(i and 128)>0;
  timer1.enabled:=true;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  SetAllDigital(CardAddress);
  DisableOtherFunctionCall:=true;
  CheckBox6.checked:=true;
  CheckBox7.checked:=true;
  CheckBox8.checked:=true;
  CheckBox9.checked:=true;
  CheckBox10.checked:=true;
  CheckBox11.checked:=true;
  CheckBox12.checked:=true;
  CheckBox13.checked:=true;
  DisableOtherFunctionCall:=false;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  SetAllAnalog(CardAddress);
  DisableOtherFunctionCall:=true;
  TrackBar1.position:=0;
  TrackBar2.position:=0;
  TrackBar3.position:=0;
  TrackBar4.position:=0;
  TrackBar5.position:=0;
  TrackBar6.position:=0;
  TrackBar7.position:=0;
  TrackBar8.position:=0;    
  DisableOtherFunctionCall:=false;
end;

procedure TForm1.DigitalOut(Sender: TObject);
var i:longint;
begin
  i:=integer(CheckBox6.checked)*1+
  integer(CheckBox7.checked)*2+
  integer(CheckBox8.checked)*4+
  integer(CheckBox9.checked)*8+
  integer(CheckBox10.checked)*16+
  integer(CheckBox11.checked)*32+
  integer(CheckBox12.checked)*64+
  integer(CheckBox13.checked)*128;
  if not DisableOtherFunctionCall then OutputAllDigital(CardAddress,i);
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
  ClearAllDigital(CardAddress);
  DisableOtherFunctionCall:=true;
  CheckBox6.checked:=false;
  CheckBox7.checked:=false;
  CheckBox8.checked:=false;
  CheckBox9.checked:=false;
  CheckBox10.checked:=false;
  CheckBox11.checked:=false;
  CheckBox12.checked:=false;
  CheckBox13.checked:=false;
  DisableOtherFunctionCall:=false;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  ClearAllAnalog(CardAddress);
  DisableOtherFunctionCall:=true;
  TrackBar1.position:=255;
  TrackBar2.position:=255;
  TrackBar3.position:=255;
  TrackBar4.position:=255;
  TrackBar5.position:=255;
  TrackBar6.position:=255;
  TrackBar7.position:=255;
  TrackBar8.position:=255;   
  DisableOtherFunctionCall:=false;
end;


procedure TForm1.Timer2Timer(Sender: TObject);
begin
    ClearDigitalChannel(CardAddress,n);
    TCheckBox(Form1.FindComponent('CheckBox'+inttostr(n+5))).checked:=false;
    inc(n);
    if n>=9 then n:=1;
    TCheckBox(Form1.FindComponent('CheckBox'+inttostr(n+5))).checked:=true;
    SetDigitalChannel(CardAddress,n);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  n:=8;
  CardAddress:=0;
  DisableOtherFunctionCall:=false;  
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  timer2.enabled:=SpeedButton1.Down;
  n:=8;
  if SpeedButton1.Down then timer1.interval:=100
    else timer1.interval:=50;
end;

procedure TForm1.RadioGroup3Click(Sender: TObject);
begin
 if RadioGroup3.Items[RadioGroup3.ItemIndex] <> '- -'  then
 begin
    CardAddress:=RadioGroup3.ItemIndex;
    ReadBackCardOutput;
 end
 else
   showmessage('Card not opened!');
end;


procedure TForm1.TrackBar9Change(Sender: TObject);
begin
  OutputPWM(CardAddress,1023-TrackBar9.position);
  Label18.caption:=inttostr(1023-TrackBar9.position);
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  if not DisableOtherFunctionCall then OutputAnalogChannel(CardAddress,1,255-TrackBar1.position);
  Label10.caption:=inttostr(255-TrackBar1.position);
end;

procedure TForm1.TrackBar2Change(Sender: TObject);
begin
  if not DisableOtherFunctionCall then OutputAnalogChannel(CardAddress,2,255-TrackBar2.position);
  Label7.caption:=inttostr(255-TrackBar2.position);
end;

procedure TForm1.TrackBar3Change(Sender: TObject);
begin
  if not DisableOtherFunctionCall then OutputAnalogChannel(CardAddress,3,255-TrackBar3.position);
  Label8.caption:=inttostr(255-TrackBar3.position);
end;

procedure TForm1.TrackBar4Change(Sender: TObject);
begin
  if not DisableOtherFunctionCall then OutputAnalogChannel(CardAddress,4,255-TrackBar4.position);
  Label9.caption:=inttostr(255-TrackBar4.position);
end;

procedure TForm1.TrackBar5Change(Sender: TObject);
begin
  if not DisableOtherFunctionCall then OutputAnalogChannel(CardAddress,5,255-TrackBar5.position);
  Label11.caption:=inttostr(255-TrackBar5.position);
end;

procedure TForm1.TrackBar6Change(Sender: TObject);
begin
  if not DisableOtherFunctionCall then OutputAnalogChannel(CardAddress,6,255-TrackBar6.position);
  Label13.caption:=inttostr(255-TrackBar6.position);
end;

procedure TForm1.TrackBar7Change(Sender: TObject);
begin
  if not DisableOtherFunctionCall then OutputAnalogChannel(CardAddress,7,255-TrackBar7.position);
  Label15.caption:=inttostr(255-TrackBar7.position);
end;

procedure TForm1.TrackBar8Change(Sender: TObject);
begin
  if not DisableOtherFunctionCall then OutputAnalogChannel(CardAddress,8,255-TrackBar8.position);
  Label17.caption:=inttostr(255-TrackBar8.position);
end;

procedure TForm1.Button1Click(Sender: TObject);
var Info: array[0..51] of longint;
i:integer;
begin
  ReadVersion(CardAddress,@Info[0]);
  label21.caption:='';
  for i:=0 to 25 do label21.caption:=label21.caption+chr(Info[i]);
  label22.caption:='';
  for i:=26 to 49 do label22.caption:=label22.caption+chr(Info[i]);
end;

procedure TForm1.ReadBackCardOutput;
var out_digital: longint;
out_analog: array[0..7] of longint;
begin
  out_digital:=ReadBackDigitalOut(CardAddress);
  DisableOtherFunctionCall:=true;
  CheckBox6.checked:=(out_digital and 1)>0;
  CheckBox7.checked:=(out_digital and 2)>0;
  CheckBox8.checked:=(out_digital and 4)>0;
  CheckBox9.checked:=(out_digital and 8)>0;
  CheckBox10.checked:=(out_digital and 16)>0;
  CheckBox11.checked:=(out_digital and 32)>0;
  CheckBox12.checked:=(out_digital and 64)>0;
  CheckBox13.checked:=(out_digital and 128)>0;

  ReadBackAnalogOut(CardAddress,@out_analog[0]);
  TrackBar1.position:=255-out_analog[0];
  TrackBar1Change(Self);
  TrackBar2.position:=255-out_analog[1];
  TrackBar2Change(Self);
  TrackBar3.position:=255-out_analog[2];
  TrackBar3Change(Self);
  TrackBar4.position:=255-out_analog[3];
  TrackBar4Change(Self);
  TrackBar5.position:=255-out_analog[4];
  TrackBar5Change(Self);
  TrackBar6.position:=255-out_analog[5];
  TrackBar6Change(Self);
  TrackBar7.position:=255-out_analog[6];
  TrackBar7Change(Self);
  TrackBar8.position:=255-out_analog[7];
  TrackBar8Change(Self);

  TrackBar9.position:=1023-ReadBackPWMOut(CardAddress);
  TrackBar9Change(Self);

  DisableOtherFunctionCall:=false;
end;

end.

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  if not DisableOtherFunctionCall then OutputAnalogChannel(CardAddress,1,255-TrackBar1.position);
  Label10.caption:=inttostr(255-TrackBar1.position);
