;       ****************************************************************************
;       ****************************************************************************
;       **          VM142: Programmable mini module with integrated PIC C        **
;       **          BurnIn test programm source code file: BurnIn.ASM  panel      **
;       ****************************************************************************
;       ****************************************************************************
;       *          (C) VELLEMAN Components NV, 2007  All rights reserved           *
;       *          Hardware & software by Pascal De Petter           	           *
;       ****************************************************************************
;       *          Hardw. Rev: P8085'1          Revision..: 0.01.00                *
;       *          and also  : -                BUILD data: 070907F01              *
;       *          OSC.......: Internal         POWER.....: 12V DC.                *
;       ****************************************************************************

;============================================================================
;       Revision History
;============================================================================
;1.00   First release.
   
;============================================================================
;       Configuration Bits
;============================================================================

_CPD                         EQU     H'3EFF'
_CPD_OFF                     EQU     H'3FFF'
_CP                          EQU     H'3F7F'
_CP_OFF                      EQU     H'3FFF'
_BODEN                       EQU     H'3FFF'
_BODEN_OFF                   EQU     H'3FBF'
_MCLRE_ON                    EQU     H'3FFF'
_MCLRE_OFF                   EQU     H'3FDF'
_PWRTE_OFF                   EQU     H'3FFF'
_PWRTE_ON                    EQU     H'3FEF'
_WDT_ON                      EQU     H'3FFF'
_WDT_OFF                     EQU     H'3FF7'
_LP_OSC                      EQU     H'3FF8'
_XT_OSC                      EQU     H'3FF9'
_HS_OSC                      EQU     H'3FFA'
_EC_OSC                      EQU     H'3FFB'
_INTRC_OSC_NOCLKOUT          EQU     H'3FFC'
_INTRC_OSC_CLKOUT            EQU     H'3FFD'
_EXTRC_OSC_NOCLKOUT          EQU     H'3FFE'
_EXTRC_OSC_CLKOUT            EQU     H'3FFF'

;==========================================================================
;       PIC16F630 C Configuration setting
;==========================================================================
	__CONFIG        _CPD_OFF & _CP_OFF & _BODEN & _PWRTE_ON & _WDT_OFF &  _MCLRE_OFF & _INTRC_OSC_NOCLKOUT
                                        ;EEPROM Data byte's Code protection OFF -> Can be readout.
                                        ;C program upcode is not protected.
                                        ;Brown-Out protection is enabled.
                                        ;Power ON timer is enabled.
                                        ;WatchDOG timer is disabled.
                                        ;C uses his own internal master clear for reset.
                                        ;C run's on own internal 4MHz. oscillator.        
	__IDLOCS        H'0142'         ;C ID-code (can be readout by programmer)

;==========================================================================
;       Register Definitions
;==========================================================================

W                            EQU     H'0000'
F                            EQU     H'0001'
;----- Register Files------------------------------------------------------
INDF                         EQU     H'0000'
TMR0                         EQU     H'0001'
PCL                          EQU     H'0002'
STATUS                       EQU     H'0003'
FSR                          EQU     H'0004'
PORTA                        EQU     H'0005'
PORTC                        EQU     H'0007'

PCLATH                       EQU     H'000A'
INTCON                       EQU     H'000B'
PIR1			     EQU     H'000C'

TMR1L			     EQU     H'000E'		
TMR1H			     EQU     H'000F'		
T1CON			     EQU     H'0010'		

CMCON			     EQU     H'0019'		

OPTION_REG	             EQU     H'0081'

TRISA			     EQU     H'0085'
TRISC			     EQU     H'0087'

PIE1			     EQU     H'008C'

PCON			     EQU     H'008E'

OSCCAL			     EQU     H'0090'

WPUA			     EQU     H'0095'
WPU			     EQU     H'0095'
IOCA			     EQU     H'0096'
IOC			     EQU     H'0096'

VRCON			     EQU     H'0099'
EEDATA			     EQU     H'009A'	
EEADR			     EQU     H'009B'	
EECON1			     EQU     H'009C'
EECON2			     EQU     H'009D'

;----- STATUS Bits --------------------------------------------------------

IRP                          EQU     H'0007'
RP1                          EQU     H'0006'
RP0                          EQU     H'0005'
NOT_TO                       EQU     H'0004'
NOT_PD                       EQU     H'0003'
Z                            EQU     H'0002'
DC                           EQU     H'0001'
C                            EQU     H'0000'

;----- INTCON Bits --------------------------------------------------------

GIE                          EQU     H'0007'
PEIE                         EQU     H'0006'
T0IE                         EQU     H'0005'
INTE                         EQU     H'0004'
GPIE                         EQU     H'0003'
T0IF                         EQU     H'0002'
INTF                         EQU     H'0001'
GPIF                         EQU     H'0000'

;----- PIR1 Bits ----------------------------------------------------------

EEIF                         EQU     H'0007'
ADIF                         EQU     H'0006'
CMIF                         EQU     H'0003'
T1IF                         EQU     H'0000'
TMR1IF                       EQU     H'0000'

;----- T1CON Bits ---------------------------------------------------------

TMR1GE                       EQU     H'0006'
T1CKPS1                      EQU     H'0005'
T1CKPS0                      EQU     H'0004'
T1OSCEN                      EQU     H'0003'
NOT_T1SYNC                   EQU     H'0002'
TMR1CS                       EQU     H'0001'
TMR1ON                       EQU     H'0000'

;----- COMCON Bits --------------------------------------------------------

COUT                         EQU     H'0006'
CINV                         EQU     H'0004'
CIS                          EQU     H'0003'
CM2                          EQU     H'0002'
CM1                          EQU     H'0001'
CM0                          EQU     H'0000'

;----- OPTION Bits --------------------------------------------------------

NOT_GPPU		     EQU     H'0007'
INTEDG                       EQU     H'0006'
T0CS                         EQU     H'0005'
T0SE                         EQU     H'0004'
PSA                          EQU     H'0003'
PS2                          EQU     H'0002'
PS1                          EQU     H'0001'
PS0                          EQU     H'0000'

;----- PIE1 Bits ----------------------------------------------------------

EEIE                         EQU     H'0007'
ADIE                         EQU     H'0006'
CMIE                         EQU     H'0003'
T1IE                         EQU     H'0000'
TMR1IE                       EQU     H'0000'

;----- PCON Bits ----------------------------------------------------------

NOT_POR                      EQU     H'0001'
NOT_BOD                      EQU     H'0000'

;----- OSCCAL Bits --------------------------------------------------------

CAL5                         EQU     H'0007'
CAL4                         EQU     H'0006'
CAL3                         EQU     H'0005'
CAL2                         EQU     H'0004'
CAL1                         EQU     H'0003'
CAL0                         EQU     H'0002'

;----- VRCON Bits ---------------------------------------------------------

VREN                         EQU     H'0007'
VRR                          EQU     H'0005'
VR3                          EQU     H'0003'
VR2                          EQU     H'0002'
VR1                          EQU     H'0001'
VR0                          EQU     H'0000'

;----- EECON1 -------------------------------------------------------------

WRERR                        EQU     H'0003'
WREN                         EQU     H'0002'
WR                           EQU     H'0001'
RD                           EQU     H'0000'

;==========================================================================
;
;       RAM Definition
;
;==========================================================================

        __MAXRAM H'FF'
        __BADRAM H'06', H'08'-H'09', H'0D', H'11'-H'18', H'1A'-H'1F', H'60'-H'7F'
        __BADRAM H'86', H'88'-H'89', H'8D', H'8F', H'91'-H'94', H'97'-H'98', H'9E'-H'9F', H'E0'-H'FF'

;==========================================================================
;
;       I/O Definition
;
;==========================================================================
;Port A:
INPUT4          EQU     H'00'           ;RA0 -> Input 4
INPUT3          EQU     H'01'           ;RA1 -> Input 3
INPUT2          EQU     H'02'           ;RA2 -> Input 2
INPUT1          EQU     H'03'           ;RA3 -> Input 1
NOT_USED        EQU     H'04'           ;RA4 -> Not used I/O.
DIAGLED         EQU     H'05'           ;RA5 -> Output -> Diag LED.
;Port C:
BUZZER          EQU     H'00'           ;RC0 -> Buzzer output.
RELAY           EQU     H'01'           ;RC1 -> Relay output.
OUTPUT4         EQU     H'02'           ;RC2 -> Output 4
OUTPUT3         EQU     H'03'           ;RC3 -> Output 3
OUTPUT2         EQU     H'04'           ;RC4 -> Output 2
OUTPUT1         EQU     H'05'           ;RC5 -> Output 1


;==========================================================================
;
;       Variable Definition
;
;==========================================================================

FLAGS                   EQU     H'20'   ;Logical flags.
TIMER1                  EQU     H'21'   ;Timer 1, Used for general delay.		
TIMER2                  EQU     H'22'   ;Timer 2, Used for general delay.		
TOGGLE_COUNTER          EQU     H'23'   ;Used for LED blinking
COUNTER                 EQU     H'24'   ;Counter 
;FLAGS:
INPUT1_OK               EQU     H'00'   ;"1" if this input was active.
INPUT2_OK               EQU     H'01'
INPUT3_OK               EQU     H'02'
INPUT4_OK               EQU     H'03'

;==> PROGRAM STARTS HERE <==
;===========================    
		ORG	0               ;Boot/Reset vector address.
 		GOTO	RESET           ;first routine after reset.

;		*********************************
;               * Delay  routine's              *
;               *********************************
DELAY100MS    	MOVLW   D'199'          ;Delay = 100mS
                MOVWF   TIMER1          
DELAY2  	MOVLW	D'166'
		MOVWF	TIMER2
		DECFSZ  TIMER2,F        
                GOTO    $-1                          
		DECFSZ	TIMER1,F
		GOTO	DELAY2	
		RETLW   0


;		************************************************
;               *        R E S E T & Power UP routine          *
;               *   Will be executed when boot PIC controller  *
;               ************************************************
RESET	        CLRWDT                          ;Clear the watchdog a power up.
                BSF	STATUS,RP0              ;Select BANK 1 for special functions
		MOVLW	B'00001111'             ;PortA: RA0->RA3 input, RA4/5 Output.
       		MOVWF	TRISA		        ;
		CLRF	TRISC                   ;All portC channels are output's.
	      	MOVLW	B'01000111'
		MOVWF	OPTION_REG              ; ** Set PIC options here **
                                                ;- Enable PORTA Pull-Up's.
                                                ;- IRQ on rising edge.
                                                ;- TMR0 = CLKOUT.  
                                                ;- TMR0 increment from Low2high.
                                                ;- Prescaler assign to TMR0.
                                                ;- Prescaler rate = 1/256.       	
                BCF	STATUS,RP0              ;Switch back to BANK 0.
                CLRF    INTCON                  ;Disable all interrupt functions.
                MOVLW   B'00000111'             ;"      "       "       "       
		MOVWF	CMCON			;turn off comparator
                CLRF    FLAGS
                CLRF	PORTA                   ;Clear all outputs.
		CLRF	PORTC                   ; "     "       "

;	        *********************************
;               *  SELFTEST Sequence routine    *
;               *********************************
START_LOOP      BCF     PORTA,DIAGLED
                CALL    DELAY100MS
                INCF    TOGGLE_COUNTER,F
                BTFSC   TOGGLE_COUNTER,0   
                BSF     PORTA,DIAGLED
                CALL    DELAY100MS      

                BCF     PORTC,OUTPUT1           ;Output 1 will be active when
                BTFSC   PORTA,INPUT1            ;Input 1 was triggered.
                GOTO    CHK_INPUT2
                BSF     PORTC,OUTPUT1
                BSF     FLAGS,INPUT1_OK         ;Confirmation flag will be set.
                BTFSS   PORTA,INPUT1
                GOTO    $-1
                
                ;
CHK_INPUT2      BCF     PORTC,OUTPUT2
                BTFSC   PORTA,INPUT2
                GOTO    CHK_INPUT3
                BSF     PORTC,OUTPUT2
                BSF     FLAGS,INPUT2_OK
                BTFSS   PORTA,INPUT2
                GOTO    $-1
                
                ;
CHK_INPUT3      BCF     PORTC,OUTPUT3
                BTFSC   PORTA,INPUT3
                GOTO    CHK_INPUT4
                BSF     PORTC,OUTPUT3
                BSF     FLAGS,INPUT3_OK
                BTFSS   PORTA,INPUT3
                GOTO    $-1
                ;
CHK_INPUT4      BCF     PORTC,OUTPUT4
                BTFSC   PORTA,INPUT4
                GOTO    CHK_TEST
                BSF     PORTC,OUTPUT4
                BSF     FLAGS,INPUT4_OK
                BTFSS   PORTA,INPUT4
                GOTO    $-1
                CALL    DELAY100MS
                ;
CHK_TEST        MOVLW   H'0F'
                XORWF   FLAGS,W
                BTFSS   STATUS,Z
                GOTO    START_LOOP                      
                ;
                CLRF    PORTC
                MOVLW   D'5'
                MOVWF   COUNTER                       
TEST_RELAY      BSF     PORTC,RELAY
                CALL    DELAY100MS
                CALL    DELAY100MS
                BCF     PORTC,RELAY
                CALL    DELAY100MS
                CALL    DELAY100MS
                DECFSZ  COUNTER,F
                GOTO    TEST_RELAY
                ;
                MOVLW   D'5'
                MOVWF   COUNTER                       
TEST_BUZZER     BSF     PORTC,BUZZER
                CALL    DELAY100MS
                CALL    DELAY100MS
                BCF     PORTC,BUZZER
                CALL    DELAY100MS
                CALL    DELAY100MS
                DECFSZ  COUNTER,F
                GOTO    TEST_BUZZER
                CALL    DELAY100MS
                CLRF    FLAGS
                GOTO    START_LOOP
                ;
                END                       ;End of source code.


                          
